(function() {

	//update on tura changed
	$(window).bind('turaStatusChanged', function(event, status) {
		if (status != 0) {
			//allow making transfers
			$('#laptopBankingLinkprzelew').removeClass('disabled');
		} else {
			//disallow making transfers
			$('#laptopBankingLinkprzelew').addClass('disabled');
			$('#laptopBankingLinkHome').click();
		}
	});
	$(window).trigger('turaStatusChanged', window.userdata['tura_aktywna']);

	function handleLink() {
		jQuery('.laptopBankingContent').children().css('display', 'none');
		jQuery(jQuery(this).attr('href')).css('display', 'block');
		jQuery('.laptopBankingHr').text(jQuery(this).text());

		if (this.id == "laptopBankingLinkHome" || this.id == "laptopBankingLinkRachunek") {
			$("#transfer_idKontrahenta").prop('disabled', false);
			$("#transfer_tytul").prop('disabled', false);
			$("#transfer_wartosc").prop('disabled', false);

			$("#transfer_idKontrahenta").val(149);
			$("#transfer_tytul").val('');
			$("#transfer_wartosc").val('');
		}

		return false;
	}

	jQuery('#laptopBankingLinkHome').click(handleLink);
	jQuery('#laptopBankingLinkRachunek').click(handleLink);
	jQuery('#laptopBankingLinkprzelew').click(handleLink);

	jQuery('#laptopBankingSendTransfer').click(function() {
		$('#laptopBankingSendTransfer').prop('disabled', true);
		//clear previous errors
		var errors = jQuery('#transfer_idKontrahenta_error, #transfer_tytul_error, #transfer_wartosc_error, #transfer_all_error');
		errors.html('');
		errors.css('display', 'none');

		//collect form data
		var fDo = jQuery('#transfer_idKontrahenta').val();
		var fDoTxt = jQuery('#transfer_idKontrahenta').find('option:selected').text();
		var fTytul = jQuery('#transfer_tytul').val();
		var fWartosc = jQuery('#transfer_wartosc').val();

		jQuery.ajax({
			url: window.links.studentAjaxMakeTransfer,
			type: 'POST',
			data: {
				transfer: {
					idKontrahenta: fDo,
					tytul: fTytul,
					wartosc: fWartosc,
				}
			},
			error: function(xhr, textStatus, errorThrown) {
				var elem = jQuery('#transfer_all_error');
				elem.html(textStatus + ' ' + errorThrown);
				elem.css('display', 'block');
			},
			success: function(data) {
				if (data.error) {
					if (data.formErrors == null) {
						var elem = jQuery('#transfer_all_error');
						elem.html(data.error);
						elem.css('display', 'block');
					}
					for (var field in data.formErrors) {
						var elem = jQuery('#transfer_' + field + '_error');
						if (elem.length == 0)
							elem = jQuery('#transfer_all_error');
						var txt = elem.html();
						if (txt.length) txt += '<br/>';
						txt += data.formErrors[field];
						elem.html(txt);
						elem.css('display', 'block');
					}
				} else {
					fWartosc = parseFloat(data.wartosc);

					//reset money counters
					jQuery('#money-number').text(data.stanKonta);
					jQuery('#laptopBankingStanKonta').text(data.stanKontaTxt);

					//add history record
					var table = jQuery('#laptopBankingPrzelewyTab tbody');
					table.prepend('<tr>' +
						'<td>' + fDoTxt + '</td>' +
						'<td>' + fTytul + '</td>' +
						'<td>' + (fWartosc < 0 ? '<span style="color:red">' + fWartosc + ' zł</span>' : fWartosc + ' zł') + '</td>' +
						'<td>Nie</td>' +
						'</tr>');

					//clean form
					jQuery('#transfer_idKontrahenta').prop('selectedIndex', 0);
					jQuery('#transfer_tytul').val('');
					jQuery('#transfer_wartosc').val('');

					//got to history
					jQuery('#laptopBankingLinkRachunek').click();
				}
			}
		});
	});

	if ((typeof window.oplaty !== 'undefined')) {
		if ((typeof window.oplaty.wartosc !== 'undefined') &&
			(typeof window.oplaty.title !== 'undefined') &&
			(typeof window.oplaty.kontrahentId !== 'undefined') &&
			(typeof window.oplaty.updated !== 'undefined') &&
			(window.oplaty.updated)
		) {
			$("#transfer_idKontrahenta").prop('disabled', true);
			$("#transfer_tytul").prop('disabled', true);
			$("#transfer_wartosc").prop('disabled', true);

			$("#transfer_idKontrahenta").val(window.oplaty.kontrahentId);
			$("#transfer_tytul").val(window.oplaty.title);
			$("#transfer_wartosc").val(parseFloat(window.oplaty.wartosc).toFixed(2));

			$("#laptopBankingLinkprzelew").click();
		} else {
			/*
			$("#transfer_idKontrahenta").prop('disabled', false);
			$("#transfer_tytul").prop('disabled', false);
			$("#transfer_wartosc").prop('disabled', false);

			$("#transfer_idKontrahenta").val(149);
			$("#transfer_tytul").val('');
			$("#transfer_wartosc").val('');
			*/
		}

		window.oplaty.updated = false;
		$('#laptopBankingSendTransfer').prop('disabled', false);
	}
})();
